//---------------------------------------------------------------------------
// FMod_TCP_BOX_DLLInterface.h                                 Copyright FiveCo 2002-2011

// for FMod_TCP_BOX_DLLInterface.dll v1.05
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//	BORLAND BUILDER C++ HEADER FILE
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#ifndef FMOD_TCP_BOX_DLLINTERFACE_H
#define FMOD_TCP_BOX_DLLINTERFACE_H
//---------------------------------------------------------------------------
enum    ComState_Enum   { State_Closed=0, State_Opened, State_Error, State_Opening, State_Closing };

enum    RS232CONFIG_Enum { Spd_4800Bps=0, Spd_9600Bps, Spd_19200Bps, Spd_38400Bps, Spd_57600Bps, Spd_115200Bps,
                            Spd_4800Bps_FC=128, Spd_9600Bps_FC, Spd_19200Bps_FC, Spd_38400Bps_FC, Spd_57600Bps_FC, Spd_115200Bps_FC };

enum    I2CSPD_Enum     { Spd_100KHz=99, Spd_400KHz=24};
//---------------------------------------------------------------------------
#define  I2CBUFFERSIZE  180
//---------------------------------------------------------------------------
#define     DECLSPEC __declspec(dllimport)
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
struct FMod_SRegisterListRead
{
    int     TYPE[2];                            // TYPE[0] : Type / TYPE[1] : Model
    bool    TYPE_Read;                          // TYPE has been read

    int     VERSION_FW[2];                      // VERSION_FW[0] : Firmware version / VERSION_FW[1] : Firmware revision
    int     VERSION_HW[2];                      // VERSION_HW[0] : Hardware version / VERSION_HW[1] : Hardware revision
    bool    VERSION_Read;                       // VERSION has been read

    bool    RESETCPU_Written;                   // RESETCPU has been written
    bool    SAVEUSERPARAMETERS_Written;         // SAVEUSERPARAMETERS has been written
    bool    RESTOREUSERPARAMETERS_Written;      // RESTOREUSERPARAMETERS has been written
    bool    RESTOREFACTORYPARAMETERS_Written;   // RESTOREFACTORYPARAMETERS has been written
    bool    SAVEFACTORYPARAMETERS_Written;      // SAVEFACTORYPARAMETERS has been written

    float   VOLTAGE;                            // Input Voltage (2Bytes.2Bytes)
    bool    VOLTAGE_Read;                       // VOLTAGE has been read

    bool    WARNINGS[32];                       // Warnings (32 individual bits)
    bool    WARNINGS_Read;                      // WARNINGS has been read
    bool    WARNINGS_Reset;                     // WARNINGS has been written

	unsigned int NBPOWERUP;						// Nb of power up (Unsigned int 32 bits)
    bool    NBPOWERUP_Read;                     // NBPOWERUP has been read

    unsigned int TIMEINSERVICE;					// Time in service in sec (Unsigned int 32 bits)
    bool    TIMEINSERVICE_Read;                 // TIMEINSERVICE has been read
    
    bool    COMOPTIONS[32];                     // 32 individual bits
    bool    COMOPTIONS_Read;                    // COMOPTIONS has been read
    bool    COMOPTIONS_Written;                 // COMOPTIONS has been written

    int     ETHERNETMAC[6];                     // Mac address (6 unsigned bytes)
    bool    ETHERNETMAC_Read;                   // ETHERNETMAC has been read

    int     IPADDRESS[4];                       // IP Address (4 unsigned bytes)
    bool    IPADDRESS_Read;                     // IPADDRESS has been read
    bool    IPADDRESS_Written;                  // IPADDRESS has been written

    int     SUBNETMASK[4];                      // Network IP subnet mask (4 unsigned bytes)
    bool    SUBNETMASK_Read;                    // SUBNETMASK has been read
    bool    SUBNETMASK_Written;                 // SUBNETMASK has been written

    int     TCPTIMEOUT;                         // TCP Timeout (1 unsigned byte)
    bool    TCPTIMEOUT_Read;                    // TCPTIMEOUT has been read
    bool    TCPTIMEOUT_Written;                 // TCPTIMEOUT has been written

    char    MODULENAME[16];                     // Name and/or description of the module (16 unsigned bytes (char))
    bool    MODULENAME_Read;                    // MODULENAME has been read
    bool    MODULENAME_Written;                 // MODULENAME has been written

    int     RS232CONFIG;                        // RS232 Baud rate (see RS232CONFIG_Enum above
    bool    RS232CONFIG_Read;                   // RS232CONFIG has been read
    bool    RS232CONFIG_Written;                // RS232CONFIG has been written

    int     I2CSPD;                             // I2C speed setting (see I2CSPD_Enum above
    bool    I2CSPD_Read;                        // I2CSPD has been read
    bool    I2CSPD_Written;                     // I2CSPD has been written

    int     TCPCONNECTIONSOPENED;               // Number of users connected to the card using TCP
    bool    TCPCONNECTIONSOPENED_Read;          // TCPCONNECTIONOPENED has been read

    float   ANALOGINPUTSTHRESHOLD;              // Threshold value used by the AD converter on inputs pins
    bool    ANALOGINPUTSTHRESHOLD_Read;         // ANALOGINPUTSTHRESHOLD has been read
    bool    ANALOGINPUTSTHRESHOLD_Written;      // ANALOGINPUTSTHRESHOLD has been written

    bool    OUTPUTS[16];                        // Controls the state of each of the output pins.
    bool    OUTPUTS_Read;                       // OUTPUTS has been read
    bool    OUTPUTS_Written;                    // OUTPUTS has been written

    bool    INPUTS[16];                         // Digital state of each inputs pin.
    bool    INPUTS_Read;                        // INPUTS has been read

    float   INPUTVOLTAGEVALUE[16];              // Voltage value of the inputs pins
    bool    INPUTVOLTAGEVALUE_Read[16];         // INPUTVOLTAGEVALUE[i] has been read


    unsigned char I2CData[I2CBUFFERSIZE];       // Array of Bytes for the I2C bus
    int     I2CData_Length;                     // Length of the data in I2CData
    int     I2CData_AskID;						// ID of the ask, specified by the user in the read function		       
    bool    I2CData_Updated;                    // I2CData has been updated

    // scan I2C
    int     NbValidI2CAdd;                      // Nb of valid I2C addressses found
    unsigned char ValidI2CAdd[127];             // Array of the valid I2C addresses
    bool    ValidI2CAdd_Updated;                // The scan I2C has been done
};
//---------------------------------------------------------------------------
struct FMod_SModule
{
    int     TYPE[2];
    int     VERSION_FW[2];
    int     VERSION_HW[2];
    int     ETHERNETMAC[6];
    int     IPADDRESS[4];

    char    MODULENAME[16];
};
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
extern "C"
{
    // Scan network to find FiveCo prducts
    int     DECLSPEC     FMod_TCP_BOX_ScanNetwork(FMod_SModule *ModuleArray, int ModuleArraySize);

// Change IP address of a module
    bool    DECLSPEC     FMod_TCP_BOX_ChangeIPAddress(int MacAddress[6], int IPAddress[4], int SubnetMaskAddress[4]);

// Open And Close Communication
    bool    DECLSPEC     FMod_TCP_BOX_OpenConnection_RS232(int AddressIP[4],
                                                                void (__closure *Data_Received_RS232)(int NbByte, void *ComID),
                                                                void (__closure *Com_Event)(int State, void *ComID),
                                                                void **ComID);

    bool    DECLSPEC     FMod_TCP_BOX_OpenConnection_MAINPORT(int AddressIP[4],
                                                                void (__closure *Data_Received_MAINPORT)(FMod_SRegisterListRead *RegList, void *ComID),
                                                                void (__closure *Com_Event)(int State, void *ComID),
                                                                void **ComID);

    bool    DECLSPEC     FMod_TCP_BOX_CloseConnection(void **ComID);

// Send and receive data - MAINPORT
    bool    DECLSPEC     FMod_TCP_BOX_Read_TYPE(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_Read_VERSION(void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Write_RESETCPU(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_Write_SAVEUSERPARAMETERS(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_Write_RESTOREUSERPARAMETERS(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_Write_RESTOREFACTORYPARAMETERS(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_Write_SAVEFACTORYPARAMETERS(void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_VOLTAGE(bool Continuous, void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_WARNINGS(bool Continuous, void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_Reset_WARNINGS(void *ComID);

	bool    DECLSPEC     FMod_TCP_BOX_Read_NBPOWERUP(void *ComID);

	bool    DECLSPEC     FMod_TCP_BOX_Read_TIMEINSERVICE(void *ComID);
	
    bool    DECLSPEC     FMod_TCP_BOX_Read_COMOPTIONS(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_Write_COMOPTIONS(bool ComOpt[32], void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_ETHERNETMAC(void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_IPADDRESS(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_Write_IPADDRESS(int IPAdd[4], void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_SUBNETMASK(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_Write_SUBNETMASK(int SubnetMask[4], void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_TCPTIMEOUT(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_Write_TCPTIMEOUT(int TCPTimeOut, void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_MODULENAME(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_Write_MODULENAME(char Name[16], void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_RS232CONFIG(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_Write_RS232CONFIG(int Config, void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_I2CSPD(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_Write_I2CSPD(int Spd, void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_TCPCONNECTIONSOPENED(void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_ANALOGINPUTSTHRESHOLD(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_Write_ANALOGINPUTSTHRESHOLD(float AnalogValue, void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_OUTPUTS(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_Write_OUTPUTS(bool Outputs[16], void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_INPUTS(bool Continuous, void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_INPUTVOLTAGEVALUE(int InputNb, bool Continuous , void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_ALL_INPUTVOLTAGEVALUE(bool Continous, void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_Read_AllRegister(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_ResetAllRegisterRead(void *ComID);

    bool    DECLSPEC     FMod_TCP_BOX_SendData_MAINPORT(void *ComID);

// Send repetitive data on MainPort
    bool    DECLSPEC     FMod_TCP_BOX_RepetitiveAskStart(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_RepetitiveAskStop(void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_RepetitiveAskSetTime(int TimeMiliSec, void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_RepetitiveAskReset(void *ComID);

// Send and receive data - RS232
    bool    DECLSPEC     FMod_TCP_BOX_SendData_RS232(unsigned char *DataBuf, int DataLength, void *ComID);
    bool    DECLSPEC     FMod_TCP_BOX_GetData_RS232(unsigned char *DataBuf, int *DataLength, void *ComID);

// Read and Write on I2C Bus
    bool    DECLSPEC     FMod_TCP_BOX_ReadWriteI2C(unsigned char *DataBuf, int DataLength, bool Continuous, int AskID, void *ComID);

// Scan network to find FiveCo prducts
    bool    DECLSPEC     FMod_TCP_BOX_ScanI2C(void *ComID);

// State and Version of the DLL
    void    DECLSPEC     FMod_TCP_BOX_VersionDLL(char* Version, int *Size);
    int     DECLSPEC     FMod_TCP_BOX_GetStateCommunication(void *ComID);

// Get Last Error of the Communication
    void    DECLSPEC     FMod_TCP_BOX_GetLastError(char* Error, int *Size);
}                                
//---------------------------------------------------------------------------
#endif
